import Typewriter from 'typewriter-effect';
import { useEffect, useRef, useState } from 'react';

const Intro = () => {
  const textsAndImages = [
    {
      text: 'Hey there, super awesome friends!',
      pathToSvg: '/src/assets/girly/girly-looking-straight.svg',
    },
    {
      text: "I'm Blo, and I have a story to share with you.",
      pathToSvg: '/src/assets/girly/girl-Rhand-bend.svg',
    },
    {
      text: 'My little brother got diagnosed with diabetes.',
      pathToSvg: '/src/assets/girly/girly-sad.svg',
    },
    {
      text: "It's like a mischievous gremlin in his body!",
      pathToSvg: '/src/assets/girly/girly-arms-up.svg',
    },
    {
      text: 'But we can outsmart it together.',
      pathToSvg: '/src/assets/girly/girl-Rhand-bend.svg',
    },
    {
      text: "That's why I became a diabetes champion to teach you all about it.",
      pathToSvg: '/src/assets/girly/girly-trophy.svg',
    },
  ];

  const [currentIndex, setCurrentIndex] = useState(0);
  const [isAnimationComplete, setIsAnimationComplete] = useState(false);
  const { text, pathToSvg } = textsAndImages[currentIndex];
  const typewriterRef = useRef<any>(null);

  useEffect(() => {
    if (typewriterRef.current) {
      typewriterRef.current.deleteAll(0.001);
      typewriterRef.current
        .typeString(text)
        .start()
        .callFunction(() => {
          setIsAnimationComplete(true);
        });
    }
  }, [text]);

  const handleClick = () => {
    if (isAnimationComplete) {
      setCurrentIndex((prevIndex) => (prevIndex + 1) % textsAndImages.length);
      setIsAnimationComplete(false);
    }
  };

  return (
    <>
      <div className="text-center">
        <div className="mx-auto my-8 w-80">
          <Typewriter
            options={{ delay: 40 }}
            onInit={(typewriter) => {
              typewriterRef.current = typewriter;
              typewriter
                .typeString(text)
                .start()
                .callFunction(() => {
                  setIsAnimationComplete(true);
                });
            }}
          />
        </div>
      </div>
      <div className="mt-4 justify-center">
        <img src={pathToSvg} alt="girly" className="mt-12" />
      </div>
      <button
        onClick={handleClick}
        className={`mt-8 border-4 border-black px-4 py-2 ${
          !isAnimationComplete ? 'bg-gray-main' : 'bg-yellow-500'
        }`}
      >
        Next
      </button>
    </>
  );
};

export default Intro;
