# INJECT Documentation

Welcome to the INJECT Documentation portal! This is your central resource for understanding, installing, and utilizing the INJECT platform.

## Overview

The INJECT platform is designed to streamline tabletop exercise management and execution. Whether you're looking to conduct training sessions, evaluate emergency response protocols, or simulate crisis scenarios, INJECT provides a powerful and flexible solution to meet your needs.

## Technical Documentation

Explore the technical documentation to gain a deeper understanding of the platform's architecture, APIs, security measures, and installation procedures.

- **[Installation Guide](tech/installation.md)**: Step-by-step instructions for deploying INJECT using Docker Compose and Nginx.
- **[Security](tech/security.md)**: Details on the security measures and practices implemented in the INJECT platform.
- **[API Documentation](tech/api/overview.md)**: Comprehensive documentation of the APIs provided by INJECT, including RESTful APIs.
- **[Architecture Overview](tech/architecture/overview.md)**: Detailed documentation on the architecture of the INJECT platform, including component definitions and change logs.

## INJECT Process

Learn about the process of conducting tabletop exercises using the INJECT platform.

- **[Inject Process](inject-process.md)**: A detailed guide on how to plan, execute, and evaluate tabletop exercises using INJECT.

## Additional Resources

Access supplementary materials and information related to INJECT.

- **[Glossary of Terms](glosary-of-terms.md)**: Definitions of key terms and concepts used in the INJECT platform.
- **[Authors](authors.md)**: Meet the team behind the development of INJECT and learn how you can get involved.
- **[Report Bugs](report-bugs.md)**: Instructions for reporting bugs, issues, or providing feedback on the INJECT platform.
- **[Acknowledgements](acknowledgements.md)**: Recognition of individuals or organizations that have contributed to the development or support of the INJECT project.
- **[Authors](authors.md)**: Meet the team behind the development of INJECT.