## Tabletop Exercise (TTX)
A tabletop exercise (TTX) is a type of teaching activity designed to train professional teams in incident response to a crisis situation. The simulated crisis happens in the context of business operations in an organization, such as a phishing attack on employees or malware infecting the company infrastructure. The team members, who hold various roles in the organization (e.g., manager or cybersecurity incident responder), discuss which actions to take to effectively respond to the emergency while following proper protocols and regulations. These discussions are facilitated by instructors, who also present an exercise debriefing at the end. TTXs are an effective educational tool that enhance incident preparedness, particularly in communication, coordination, and collaboration.

## INJECT Exercise Platform (IXP)
The INJECT Exercise Platform (IXP) is an interactive web application designed to support the delivery and evaluation of TTXs. Designers use the platform to instantiate an exercise definition, which prescribes the exercise story, injects, available tools, and milestones. An exercise definition is implemented as a set of structured text-based files (in YAML format) that are both human- and machine-readable. IXP automates a substantial portion of the TTX by providing trainees with tools and inject response templates, significantly reducing the workload and personnel requirements for TTX delivery.

## Inject
An inject is a pre-scripted message, such as an email, provided to trainees during a Tabletop Exercise (TTX). Its purpose is to move the scenario forward and prompt additional actions. For example, an inject can inform the trainees about a data breach in their company, requiring them to respond accordingly. [NIST] (https://nvlpubs.nist.gov/nistpubs/Legacy/SP/nistspecialpublication800-84.pdf)

## Tool
A tool is a simplified simulated version of a real-world computer application or service. Its purpose is to allow trainees to perform actions to respond to injects. For instance, instead of using an actual email client, trainees use an “email” tool to send and receive in-exercise messages. Another example is a “browser” tool that returns an in-exercise website based on the provided exercise URL.

## Milestone
A milestone is a true/false condition that denotes whether a specific team reached a certain important situation in the TTX scenario. Its purpose is to track each team’s progress through the TTX. For example, it can mark that a team used an email tool to respond to a query from a manager. The exercise milestones can be completed in any order, and there is rarely a single correct solution, which makes team assessment challenging.
