# Learning Activities

## In a nutshell
- Learning Activities (LAs) are actions that the trainee performs that are directly reflected in the platform. This then allows us to evaluate their performance. 
- Each LA is linked to just one Learning Objective (LO). One LO can link any number of LAs to itself. 
- We consider the ideal number to be 5 LAs for a single LO. 
---

## Where are we in the INJECT process?

![](../../images/3.svg)

---


## Basics 
The exercise designer must be clear about three things for each LA: 

1.	**What specifically the participant is to do/practice**. 
For example, he/she has to decide, analyze, present, discuss, etc. The chosen activity must make sense in relation to the LO to which the LA relates. 

2.	**How will the participants`action manifest itself in the platform** 
If we omit this step, it is difficult for us to measure the fulfilment of the action. This condition does not mean that everything during the exercise must happen directly in the platform. For example, you can give participants an LA which purpose will be to discuss an issue in detail; we will link it to the platform with a confirmation button (described further) that participants activate at the end of the discussion. This step is fundamentally related to the following one and cannot be simply separated.

3.	**We need to know which inject will trigger this LA**. 
In other words, the LA will not happen unless the participant receives the necessary cue. It is not necessary for each LA to have a specific inject. On the contrary, one inject can easily become the source for several LAs. For example, a simple incident report will trigger a series of LAs based on the incident response plan. 

## How to specify Learning Activities? 
### 1.

**LA is always determined in relation to LO**. Let's illustrate this with an example where we create an LA for this LO: Handle the incident according to the process described in their manual. 

Now we need to find an answer to what exactly the participants should do. We can find this out in several ways - but mainly from the processes described, from interviews with experts or from our own experience.

If there is not an exact match to a given LO, or if we want to get more variety into our LAs, we can use these action words: 

```
Identify, Search, Summarize, Predict, Decide, Estimate, 

Conduct, Compare, Examine, Present, Implement, Act out, 

Break down, Argue, Negotiate, Criticize, Reflect, 

Review, Write, Solve.
```


In our case, we have created the following three LAs. 

LA1.1: Participants must **conduct** an incident analysis. 

LA1.2: The parties must **decide** whether the incident needs to be escalated. 

LA1.3: Participants should **identify** the next appropriate course of action. 

### 2.
Now we have to decide **what they will specifically do in the platform within the given activities and what injects will make them do it.** These steps are closely linked, they cannot be separated. 
 
In the platform, participants can generally perform the following actions:

- *Clicking the confirmation button after participants have performed the LA* - this manifestation is great for LAs that don't have another clear manifestation in the platform, specifically: 
    - LA takes place primarily in the minds of the participants - e.g. analysing documents, familiarising themselves with the situation, reading instructions. 
    - LA takes place outside the platform: participants have to discuss something, present something, be interviewed by a journalist, etc. 

- *Establishing email communication* - participants sent the first email to the given address. LA is filled just by sending the email. Note that for each unique address, this action is only recorded once by the platform. 

- *Email response from the instructor* - very often just sending an email will not be enough to show us that LA is fulfilled. In fact, the previous manifestation does not evaluate the content. In this case, the instructor reads the email and if the content is appropriate, he/she responds using a template that also indicates the fulfillment of the LA in the platform. 

- *Submitting an interactive inject* - participants submit a questionnaire, scale or decision.

- *Response in free form inject with open response* - the manifestation is already a separate sending, we do not need to respond to the sent content further within the scenario.

- *Instructor response to free form inject with open response* - same principle as instructor email response.	

- *Participants used a predefined tool.* Tools are a specific capability of the platform designer. We describe them in more detail in section called [Tools](../specify/tools.md)).	


But what is the most appropriate way of the platform manifestation? 
The answer to this question depends largely on your experience and intuition. It is true that the same LA can manifest in different ways, and it is always closely related to the inject options. The designer's task is to choose the one that makes sense in terms of the LO. Let's flesh this out further and work with the LA from the previous step. 

Note: **In the Specification Phase, you cannot proceed in a completely linear fashion**. The following examples may not make sense to you until you read the description of [Injects](../specify/injects.md).

#### Examples: 

a.	LA1.1: Participants must conduct an incident analysis.

-	As exercise designers, we decided that the inject that would be associated with this LA would be to report the incident via email. However, this email will not contain all the necessary information. Therefore, we know that the logical outcome of a successful analysis will be to query the missing information. 
-	Thus, the most appropriate manifestation in the platform will be an email response from the instructor. Simply establishing email communication would not suffice as a relevant manifestation in the platform, we need to be sure that the participant has asked for what they really need to know. 
-	Is there another way to do it? Yes, we could send a report to the participants and let them confirm the analysis with a confirmation button. Or we could send participants a Free form inject with an open response and the action in the platform would then be the instructor's response. 

b.	LA1.2: The parties must decide whether the incident needs to be escalated.

-	Again, it depends on the injection. Fulfillment of this activity can be manifested, for example, by sending an interactive decision injection, an email response from the instructor, or by the instructor's response to a free form inject.

c.	LA1.3: Participants should identify the next appropriate course of action.

-	Similarly, participants here may receive an email from a supervisor as an inject, asking them for their next suggested steps. The manifestation can be just sending the email.  
-	Or they can get the same question in a free form injection with an open-ended answer, and the manifestation can also just be a simple submission. 

The above are just examples. Once you understand the principles, you can easily make a series of connections to fit your scenario. 












<div class="navigation" markdown>
  [&larr; Learning objectives](../specify/learning_objectives.md){ .md-button }
  [Injects &rarr;](../specify/injects.md){ .md-button }
</div>

<div class="navigation" markdown>
  [Specification Phase Overview](../specify/overview.md){ .md-button }
</div>
