## System Overview

The INJECT Exercise Platform is architecturally structured into two distinct components: the frontend and the backend. This separation allows for clear delineation of roles and responsibilities, enhancing modularity and scalability within the system.

The architecture of the INJECT Exercise Platform can be visualized as follows:

``` mermaid
flowchart LR
    A(INJECT) --> B(BACKEND)
    A --> C(FRONTEND)
    C --> D(TRAINEE PANEL)
    C --> E(INSTRUCTOR PANEL)
    C --> F(ANALITICS PANEL)
    C --> J(EXERCISE PANEL)
    B --> G(EXERCISES)
    B --> H(EXERCISE DEFINITIONS)
    B --> I(RUNNING EXERCISE)
    B --> K(AUTHENTICATION)
```

This diagram illustrates the high-level architecture of the INJECT Exercise Platform. It is composed out of these parts:

* Frontend: The frontend component serves as the user interface of the INJECT Exercise Platform, allowing users to interact with the system.
It includes four main parts:
    * Trainee View: This view is designed for trainees participating in tabletop exercises. It provides functionalities tailored to their role, such as accessing exercise scenarios, submitting responses, and general interaction with the exercise.
    * Instructor View: This view is tailored for instructors or facilitators overseeing tabletop exercises. It offers capabilities for monitoring trainee progress, and providing guidance during the exercise.
    * Analytics: The analytics view provides insights and analytics related to the tabletop exercises conducted on the platform. It includes metrics such as participation rates, completion times, and performance trends.
    * Exercise Panel: The exercise panel enables users to view and manage exercises available on the platform, including creating new exercises, editing existing ones, and organizing exercise-related resources.

* Backend: The backend component serves as the backbone of the INJECT platform, handling data management, authentication, and communication with the frontend. It includes several parts:
    * Exercises: This module manages the creation, modification, and storage of tabletop exercises on the platform.
    * Exercise Definitions: The exercise definitions module stores templates and definitions for different types of exercises. These definitions include details such as injects, emails and tools. It also checks and ensures that definitions are correctly configured and set up. For a more in-depth explanation of definitions, please refer to [definitions architecture.](definitions.md)
    * Running Exercise: This module manages the execution and runtime aspects of tabletop exercises, including tracking the progress of ongoing exercises and managing the flow of injects.
    * Authentication: Handles user authentication and authorization, ensuring secure access to the platform's functionalities.

## Used Technology
### Backend Technology
The backend component of the INJECT Exercise Platform is built using Python and Django, a high-level web development framework. Key components of the backend architecture include:

* Python Backend: The backend of the INJECT Exercise Platform is implemented using Python.
* Django Framework: Django, the most popular web development framework for Python, is used to build the backend application. Django provides robust features for database management, user authentication, and more.
* GraphQL API: The backend exposes a GraphQL API for communication with the frontend. GraphQL allows efficient data fetching and enables the client to request only the data it needs.
* Django REST Framework: For file transfers and other functionalities not supported by GraphQL, a REST API is implemented using Django REST Framework.

### Frontend Technology
The frontend component of the INJECT Exercise Platform utilizes modern web technologies including:

* React Frontend: The frontend application of the INJECT Exercise Platform is developed using React, library for building user interfaces.
* TypeScript: TypeScript is used instead of JavaScript to ensure type safety and improve code quality.
* React Hooks: React hooks play a crucial role in modern React programming, providing essential features such as state management and performing side effects.
* Libraries and Tools: Various libraries and tools, including Yarn, Vite, Apollo Client, and Generouted, are utilized for package management, building, data management, and routing within the frontend application.