# Frontend (React)

Monorepo of INJECT Frontend

Subrepos:

- frontend - Main repository hosting Vite-related code, main components specific to INJECT Frontend (sans Dashboard and soon Exercise Panel)
- graphql - Library for the communication with the GraphQL-based backend. Library is specifically made to easen development of GraphQL centric code to ensure higher consistency of queries.
- shared - Shared Library between all parts of the project containing functional and templating components
- tests - Service repo for testing typescript functions handling some algorithmic things
- backend - Submodule to an actually supported backend

## How to run

Install Node 20 LTS, Yarn, Python 3.8

```
# https://stackoverflow.com/questions/16773642/pull-git-submodules-after-cloning-project-from-github
git submodule update --init

cd backend/
curl -sSL https://install.python-poetry.org | python3 -
poetry install
poetry run python manage.py migrate
poetry run python manage.py createcachetable
cd ..

yarn
# run backend server on a known address, set it appopriately in src/config.ts and also in Backend KNOWN_HOSTS
# first run backend in different pane
poetry run python manage.py runserver

# then after running backend, run frontend dev
yarn dev
# if on windows, make sure that Git is installed and run on GitBash
GIT_ENABLED=1 yarn dev

# if building

# this step is mandatory, it compiles `graphql` and `shared` library
yarn prebuild
# this builds the `dist/` artifact from `frontend` repo.
yarn build
```

## Docker deployment

Repository has a prepared Dockerfile which can be compiled accordingly. 

```
docker build . -t inject-fe
```

To deploy the docker container, you only need to execute:

```
docker run -p 80:80 inject-fe
```

During runtime of the container it's required to bind the container to a given `backend` instance. This can be done accordingly

```
docker run -p 80:80 -e VITE_HTTP_HOST=secure-be.inject.muni.cz -e VITE_HTTP_WS=wss://secure-be.inject.muni.cz/ttxbackend/v1/graphql inject-fe
```

Please mind, that changing environment variables requires restart of the container if done during the runtime.

## How to test the Monorepo

Run `yarn test`, the tests should take no more than a minute now.

Currently the testing toolchain is still not very sufficient, this will be remedied in the future. 

## Project QC Features

The code uses a set of ESLint and Prettier rules to improve legiblity and enforce some React conventions.

The repo is littered with various README.md and GUIDELINES.md files that dictate rules of the repository. Rules are enforced during MRs

## Currently used libraries

- Ahooks (implements common React Hooks for general usage)
- Generouted (allows for easier creation of router configuration)
- GraphQL Codegen (allows for automatic typing of GraphQL queries)
- BlueprintJS (for UI)
- emotion CSS (for CSS-in-JS and type control)
