# INJECT
This repository contains the INJECT project.


## Quick list
- [Documentation](#documentation)
- [Running the Application](#running-the-application)
- [Running the Application with Docker](#running-the-application-with-docker)
- [Formatting with Black](#formatting-with-black)
- [Django Administration Panel](#django-administration-panel)
- [Django-nose unit tests](#django-nose-unit-tests)


### Versioning
Backend uses [Semver](https://semver.org/) with `poetry`. The current backend version can be manually
found in the [pyproject](../pyproject.toml) file or checked by running `poetry version`. 
More details can be found [here](./dev/README.md#backend-versioning).


### Documentation
The REST API documentation can be interacted with through swagger documentation available at http://127.0.0.1:8000/ttxbackend/api/v1/doc.

GraphQL documentation can be interacted with through GraphiQL interface available at http://127.0.0.1:8000/ttxbackend/api/v1/graphql/.


### Running the Application:
```
curl -sSL https://install.python-poetry.org | python3 -
poetry install
poetry run python manage.py migrate 
poetry run python manage.py runserver
```


### Running the Application with Docker:
There is a `Dockerfile` present in this repository, which can be used to build an image of the current version of the backend. 
Image can be built with this command:
```bash
docker build -t backend .
```
Once the image is created, you can start the container with this command:
```bash
docker run --name backend -p8000:8000 -d backend gunicorn
```
You can access the backend the way described in the same way as when running locally.

Image allows running of unit tests as well, this can be done via:
```bash
docker run --rm backend test
```


### Deployment
The backend is made to be deployed using [gunicorn](https://gunicorn.org/) with [uvicorn](https://www.uvicorn.org/) workers.
Specific versions of these servers are included in the poetry environment.
To start the server, run this command:
`poetry python -m gunicorn ttxbackend.asgi:application -k uvicorn.workers.UvicornWorker`

This will start a gunicorn server using uvicorn workers. `uvicorn` is required because `gunicorn`
does not support websockets, which are necessary for GraphQL subscriptions.

Currently, it is not recommended to use **more than 1 worker**.

An additional environment variable `HOST_ADDRESSES` must be set with a comma-separated list of
allowed host addresses.

In Docker this can be done followingly:
```bash
docker run --name backend -e HOST_ADDRESSES="172.26.0.1,192.168.0.1" -p8000:8000 -d backend gunicorn
```

### Formatting with Black
[Black](https://pypi.org/project/black/) is included in the poetry environment and configured appropriately. 
To reformat code run `black .`, to check if your code is formatted properly run `black . --check` .


### Django Administration Panel
Django administration panel is a tool for the management of data created by the application. 
You can create, edit and update exercise data, however, 
note that these actions are in no way equivalent to the graphql queries and mutations, 
which means that an exercise cannot be fully set up and started using just the admin panel.

To access the admin panel, first, run `poetry run python manage.py createsuperuser` and create an admin account. 
Then visit http://localhost:8000/ttxbackend/api/v1/admin/ and log in.


## Django-nose unit tests
Project includes unit tests, which generate coverage report with the help of django-nose library. 
All tests can be run with following command: 
`poetry run python manage.py test`
