## Initial user creation

INJECT Exercise Platform without prior setup does not generate any standard admin user, that you may use to login and manage the platform.

There are currently two ways how you may generate said Admin user.

### Direct creation via Docker

After launching the deployment, please wait for all migrations to finish and execute following command. Navigate your shell to the folder of your Docker compose configuration directly and

- Execute a shell session in the backend container, please make sure to navigate your shell to the folder where your Docker compose resides at

    ```
    docker compose exec backend python manage.py shell
    ```

- Create a admin using the Django shell. Replace `email@test.com` and `long_and_secure_password` with your desired admin credentials.:

    ``` python
    from user.models import User
    User.objects.create_superuser(username="email@test.com", password="long_and_secure_password")
    ```

- These steps may be further simplified/automized by merging both of these commands accordingly

    ```
    docker compose exec backend python manage.py shell -c "from user.models import User; User.objects.create_superuser(username="email@test.com", password="long_and_secure_password");"
    ```

After creation of the user, you may login into the IXP.


If you need to create normal users, then please refer to the [User Onboarding](./../security.md#user-onboarding).

<div class="navigation" markdown>
  [&larr; Installation overview](overview.md){ .md-button }
</div>
