# Installation

The INJECT Exercise Platform (IXP) comprises two main components: the frontend and the backend.
This separation allows for modular development, easier maintenance, and scalability of the platform.
Below, we'll walk you through the unified process of installation for frontend as well as for backend.

For a deeper understanding of the overall architecture of the IXP,
you can refer to the [architecture overview](../architecture/overview.md) in the documentation.

## Prerequisites

### Hardware Requirements

Before you begin, ensure that you have the following:

* A server with at least 2 core CPU and 4 GB RAM
* A 64-bit x86 architecture
* Root or sudo access to the server
* Approximately 0.5 GB of disk space for both the platform and files needed for exercises

These requirements ensure that the backend server can handle data processing efficiently while serving the frontend interface smoothly.

### Software Requirements

* Linux operating system: Debian 11 or 12 is recommended
* [Docker Engine](https://docs.docker.com/engine/install/).
* [Docker Compose](https://docs.docker.com/compose/install/linux/) with recommended version v2.27.0

Make sure to install Docker and Docker Compose before proceeding with the installation. 

## Installation (Docker)

Start with choosing Docker Compose preset [https](./https/base-setup.md) for a TLS certificate by Let's Encrypt,
or [https-owncert](./https/owncert.md) for setup with your own certificate.
After choosing one and downloading it continue with downloading backend and frontend source code to the Compose preset folders.

Source code for frontend and backend can be downloaded in these following URLs  
- [Frontend](https://gitlab.fi.muni.cz/inject/frontend/-/releases)  
- [Backend](https://gitlab.fi.muni.cz/inject/backend/-/releases)


### Compatibility

To ensure that the downloaded versions of frontend and backend work correctly,
check that they have the same version in the name on their respective `Releases` pages.
E.g. `v2.0.0` of the frontend is fully compatible with `v2.0.0` of the backend.

1. Unzip the individual archives.
1. Rename the unzipped directories to `frontend` and `backend` respectively.
1. Ensure that the `.env` file in the root directory is set up correctly as per the [setup guide](./setup.md).
1. Run `docker compose up`, if any errors occur please refer to the troubleshooting guides.
1. Add admin (superuser) account by following [these instructions](./users.md).

## Conclusion

By following the installation guide, you'll be able to successfully set up and deploy the IXP.
After completing the installation,
you may download this [Intro Definition](https://gitlab.fi.muni.cz/inject/inject-docs/-/raw/main/files-from-repos/intro-definition.zip?ref_type=heads&inline=false)
and try to upload it to test the platform's functionality.

If you encounter any bugs,
please refer to the [Known Issues and Fixes](../../known-issues.md) page for troubleshooting steps and solutions.
If you require further assistance, don't hesitate to report them to us.
The [Report issue](../../report-issue.md) page includes instructions on how to report bugs.

<div class="navigation" markdown>
  [&larr; Home](../../index.md){ .md-button }
  [Troubleshooting](troubleshooting.md){ .md-button }
</div>
