# Installation

The INJECT Exercise Platform (IXP) comprises two main components: the frontend and the backend.
This separation allows for modular development, easier maintenance, and scalability of the platform.
Below, we'll walk you through the unified process of installation for frontend as well as for backend.

For a deeper understanding of the overall architecture of the IXP,
you can refer to the [architecture overview](architecture/overview.md) in the documentation.

## Prerequisites

### Hardware Requirements

Before you begin, ensure that you have the following:

* A server with at least 1 core CPU and 4 GB RAM
* A 64-bit x86 architecture
* Root or sudo access to the server

These requirements ensure that the backend server can handle data processing efficiently while serving the frontend interface smoothly.

### Software Requirements

* Linux operating system: Debian 11 or 12 is recommended
* [Docker Engine](https://docs.docker.com/engine/install/).
* [Docker Compose](https://docs.docker.com/compose/install/linux/) with recomended version v2.27.0

Make sure to install Docker and Docker Compose before proceeding with the installation.

The installation files for deployment are zipped and available on GitLab.
You can download them from [here](https://gitlab.fi.muni.cz/inject/inject-docs/-/raw/main/files-from-repos/deployment-files.zip?ref_type=heads&inline=false)  

These files include all necessary configuration files, scripts, and the `.env` file needed for deployment.

{%
   include-markdown "../../files-from-repos/nginx-README.md"
   start="---
tags: used_in_docs
---"
%}

## Conclusion

By following the installation guide, you'll be able to successfully set up and run the IXP.
If you encounter any bugs or require further assistance, don't hesitate to report them to us.
The [Report bugs](../report-bugs.md) includes instructions on how to report bugs.
