For version 2.0.0 of IXP, download Compose preset folder for HTTPS Deployment with your own
certificates from
[here](https://gitlab.fi.muni.cz/inject/docker-deployment/-/package_files/222/download).

## HTTPS Deployment with your own certificates (advanced)

For HTTPS deployment with your own certificates, include `fullchain.pem` and `privkey.pem` into the
`docker/nginx/https-owncert/certificates/` directory. If the format of the keys or selection of keys
does not suffice, it's advised to modify the `nginx.conf.template` file and change the related
configuration in line `:32-33`. Docker compose mounts the `./certificates` folder as
`/etc/nginx/certificates/` in the Nginx container. All of this has to be done before executing step
5 listed in the main [installation](../overview.md) guide.

Name of the nginx configuration file is intentionally named as such due to `01-substitute-env.sh`
script, which substitutes `INJECT_DOMAIN` variable with environment variable value.

Please ensure that:

- `INJECT_DOMAIN` is setup to your desired hostname in the `.env` file enclosed in the
    `docker/nginx/https-owncert` directory
- `INJECT_SECRET_KEY` is changed to a truly random string of characters of at least 50 characters
    long
- `01-substitute-env.sh` is executable via `chmod +x 01-substitute-env.sh`.

Then you may execute `docker compose up -d` and your deployment is up and running

<div class="navigation" markdown>
  [&larr; Installation overview](../overview.md){ .md-button }
  [Basic HTTPS](./base-setup.md){ .md-button }
</div>
