# How to upgrade definition version?

If you want to upgrade the current definition to a new version, use the following
[CHANGELOG](CHANGELOG.md).

## How to proceed:

1. Take your current definition, and in `config.yml`, check the version.

2. Change the version in `config.yml` to a new version.

3. Use the [CHANGELOG](CHANGELOG.md) and start making changes step by step from your current
    version to the newest version that is compatible with IXP.

4. Make one single change at a time.

5. Be sure to make the change for all the concerning files and their attributes before proceeding
    with the following change.

6. Each version contains information about changes and a structured description of affected files
    and their arguments.

7. Note that not every change is reflected in the files, some changes are only concerned with the
    behaviour of certain definition aspect rather than syntax change in the YAML files.

8. Lastly, check the new version against [definition documentation](README.md) to see if the
    arguments in the files are the same.

9. Zip the definition and upload it to the IXP for the last validation.

10. **Done.** Enjoy your upgraded version!

## Example:

- Current version: **0.8.0**

- New version: **0.12.1**

- In the `config.yml` change the field `version` from 0.8.0 to 0.12.1.

### 0.8.0 to 0.9.0

1. In the [CHANGELOG](CHANGELOG.md), find the first subsequent definition version to the current
    definition version, which is, in this case, **0.9.0**.
2. removing the field `auto` in `injects.yml` is the only change.
3. Open `injects.yml`. Remove the field `auto` from every inject category.
4. Save the file.
5. Check the `injects.yml` against the `injects.yml` structure in the
    [definition documentation](README.md).

### 0.9.0 to 0.9.1

1. In the [CHANGELOG](CHANGELOG.md), find the first subsequent definition version to the current
    definition version, which is, in this case, **0.9.1**.
2. The only change is the addition of the optional field `initial_state` to milestones. Because the
    field is optional and the change indicates a new feature, it won't affect the functionality of
    your definition.
3. Skip the change.

### 0.9.1 to 0.10.0

1. In the [CHANGELOG](CHANGELOG.md), find the first subsequent definition version to the current
    definition version, which is, in this case, **0.10.0**.
2. The change lies in the changing behavior of specific injects that do not contain a `content`
    field. This is, again, a change of behavior that does not affect the current definition.
3. Skip the change.

### 0.10.0 to 0.11.0

1. In the [CHANGELOG](CHANGELOG.md), find the first subsequent definition version to the current
    definition version, which is, in this case, **0.11.0**.
2. The change lies in changing the behavior of `delay` in `injects.yml`. If the definition uses
    **delay** functionality, this could change the desired behavior of the current definition.
3. The designer has to test if the exercise behaves as expected.
4. If it does, then skip the change. If it does not, then change the design of the affected part.

### 0.11.0 to 0.12.0

1. In the [CHANGELOG](CHANGELOG.md), find the first subsequent definition version to the current
    definition version, which is, in this case, **0.12.0**.
2. The change is replacing the `text` field in `questionnaires.yml` for more generic `content` as
    described in [Overview](README.md).
3. Check the `content` structure in the [definition documentation](README.md).
4. Change every `text` field in `questionnaires.yml` for `content`.
5. Save the file.
6. Check the `questionnaires.yml` against the `questionnaires.yml` structure in the
    [definition documentation](README.md).

### 0.12.0 to 0.12.1

1. In the [CHANGELOG](CHANGELOG.md), find the first subsequent definition version to the current
    version, which is, in this case, **0.12.1**.
2. The change lies in adding and enabling functionality for role-based exercises. Therefore, no
    change is needed.
3. Skip the change.

- Create a new .zip archive and upload it to the IXP.
- The upload process will check the definition for errors.

**You have successfully upgraded the definition version.**
