## 0.12.1

Enable specification of `roles` in `email` type injects.

### injects.yml

- allow specifying `roles` in control blocks inside `email` type injects

## 0.12.0

Replace `text` field by `content` in `Questionnaire` questions. From now, the questions of
questionnaires can be formatted via `content`. #251

### questionnaires.yml

- remove field `text` of questions
- add field `content` to questions

## 0.11.0

Change the behavior of `delay` on injects. Whenever an alternative is delayed, the condition is now
checked throughout the duration. If the condition becomes false, the inject is cancelled and a new
alternative can be selected. #266

### injects.yml

- change behavior of `delay` field

## 0.10.0

Change the behavior of `info` alternatives. When an alternative contains no `content`, it will not
create an action log. #264

### injects.yml

- change behavior of `content` field in `info` injects

## 0.9.1

Add option to specify initial state for milestones. #263

### milestones.yml

- add optional field `initial_state`

## 0.9.0

Removed manual injects. #228 All injects are now considered to be **automatic injects**.

### injects.yml

- remove field `auto`

## 0.8.0

Add a new required concept called `learning objectives`. This concept _must_ be included in all
exercise definition. #170

### objectives.yml

- added new file

### milestones.yml

- add field `activity`

## 0.7.0

Add simple questionnaires. #165

### channels.yml

- add new channel type `form`

### questionnaires.yml

- added new file

## 0.6.1

Add overlay to injects. #153

### injects.yml

- add field `overlay` to `info` and `email` injects

## 0.6.0

Added a new concept called `channels` #151. This concept is saved in a new `channels.yml` file. See
[readme](README.md#channelsyml) for details.

### config.yml

- remove `enable_email` field
- remove `team_visible_milestones` field, team visible milestones can now be specified without this
    flag

### channels.yml

- added this new required file

### injects.yml

- remove field `hidden`
- rename field `injects` to `alternatives`
- add field `type` to inject
- specify new types of alternatives, see [readme](README.md#alternatives-_info_)

### tools.yml

- remove old `content`, `content_path`, `file_name` fields
- remove old `milestone_condition`, `activate_milestone`, `deactivate_milestone`, `roles` fields
- add new fields `content` and `control`, see [readme](README.md#common-definitions) for details

### email.yml

- remove `activate_milestone`, `deactivate_milestone` fields from email address
- add `control` field to email address
- remove old `content`, `content_path`, `file_name` templates from email templates
- remove `activate_milestone`, `deactivate_milestone` fields from templates
- add new fields `content` and `control` to email templates, see
    [readme](README.md#common-definitions) for details

## 0.5.1

Allow using directories of files instead of single YAML files inside the definition #128

## 0.5.0

### injects.yml

- add inject field `subject`

## 0.4.1

### config.yml

- remove `team_file_upload` field, the feature is now always enabled
- remove `custom_team_names` field, team names have been removed from the definition, it is now a
    parameter when creating an exercise
- remove `team_count` field, it is now a parameter when creating an exercise

### teams.yml

- temporarily removed from the definition

## 0.4.0

Introduce simplified syntax for `activate_milestone` and `deactivate_milestone`, which replaced the
old field `reach_milestone`. #98

Instead of the old syntax from `reach_milestone` reminding logical condition, the new fields
`(de)activate_milestone` have a simple enumeration of milestones, which could be separated by a
comma, space, or comma followed by space.

### injects.yml

- inject field `reach_milestone` is replaced by fields `activate_milestone` and
    `deactivate_milestone`

### tools.yml

- response field `reach_milestone` is replaced by fields `activate_milestone` and
    `deactivate_milestone`

### email.yml

- email and template field `reach_milestone` is replaced by fields `activate_milestone` and
    `deactivate_milestone`

## 0.3.0

### milestones.yml

- add field `final` to milestones #74

## 0.2.0

Introduce support for markdown content in `injects`, `tool responses` and `email templates`. #84

Add new optional folder `content` to the definition file structure. This folder should contain
markdown files which will be pointed to by `content_path` fields. Only one of the `content`,
`content_path` fields can be set at the same time. If neither field is set, then the content is
considered to be empty.

### tools.yml

- rename response field `answer` to `content`
- add field `content_path` to responses

### inject.yml

- add field `content_path` to injects

### email.yml

- add field `content_path` to emails

## 0.1.1

### email.yml

- Add `organization` field to email addresses #83

### injects.yml

- Add `organization` field to inject categories #83

## 0.1.0

Initial version, no changes.
