# Known Issues and Fixes

This page outlines the known issues associated with the platform and provides guidance on how to
resolve or work around them.

## Data does not update automatically

### Issue

Data such as injects in the individual channels, milestones reached by the selected team, or
exercises in the exercise panel may not update automatically upon entering the platform.

### Cause

The issue is caused by WebSocket connections not being correctly established.

### Solution

Refresh the page in your browser. This forces a reload of all displayed data and usually leads to a
properly established connection, causing data to update automatically.

## Unauthorized REST Endpoint Request

### Issue

When creating a request on the REST endpoint as a non-authorized user, instead of a
`Permission Denied` pop-up, an HTML error 500 is returned and this is shown:

```
<!doctype html>
<html lang="en">
<head>
  <title>Server Error (500)</title>
</head>
<body>
  <h1>Server Error (500)</h1><p></p>
</body>
</html>
```

## File Upload for Email Over 100MB

### Issue

When uploading a file for an email that's over 100MB, an error pops up with the message
`undefined - undefined`.

### Cause

The maximum allowed file size for uploads is currently set to 100MB.

### Solution

Ensure that the file size is under 100MB before attempting to upload it.

## Exercise cannot be started after outage

### Issue

Cannot start an exercise even though all exercises are stopped.

### Cause

When an exercise is running, a special lockfile is created. This lockfile is deleted automatically
when the exercise is stopped. If the backend server crashes or the server is manually stopped during
a running exercise, this file will not be properly deleted, preventing from starting this specific
exercise again. The server is set up to automatically delete all lockfiles on startup. However, if
this issue persists even after restarting the server, it could be possible that the process failed.
Ensure that no lockfiles are present in the `data` directory with the name `exercise-<ID>.lock`. The
`data` directory is located in the base directory of the backend. These files can be deleted while
the server is running, however only if there are no actual running exercises.

## Conclusion

If you require further assistance, don't hesitate to report issues to us. The
[Report issue](report-issue.md) page includes instructions on how to report bugs.
