# Technical documentation – Overview

This section provides comprehensive information and resources for understanding, installing, and maintaining the INJECT Exercise Platform (IXP).
Each part of this section is designed to help developers, system administrators, and other stakeholders effectively utilize the platform.

## Contents

### 1. Installation Guide

- **[Installation Guide](installation.md)**:
  This guide provides detailed, step-by-step instructions for deploying the IXP using Docker Compose and Nginx.
  It covers prerequisites, environment variables configuration, HTTPS deployment, creating a superuser, and troubleshooting tips.

### 2. Authentication and Authorization

- **[Authentication and Authorization](security.md)**:
  This section outlines the authentication and authorization mechanisms implemented in the IXP.
  It includes detailed descriptions of the authentication processes, such as
  how users are authenticated using Django's session system with cookies, and
  authorization mechanisms, detailing the role-based access control (RBAC) and access control lists (ACL) used to manage user permissions.
  By understanding and following the guidelines, you can protect your data and ensure that only authorized users have access to sensitive information.

### 3. API Documentation

- **[API Overview](api/overview.md)**:
  This document provides an overview of the APIs available in the IXP, explaining the purpose and usage of each API.
  It sets the stage for more detailed documentation found in the subsequent files.
- **[Swagger Documentation](api/swagger-docs.md)**:
  Detailed documentation generated from the OpenAPI specification, providing a user-friendly interface to explore and test the API endpoints.

### 4. Architecture

- **[Architecture Overview](architecture/overview.md)**:
  This document gives a high-level overview of the architecture of the IXP,
  describing the main components, their interactions, and the overall system design.
  It includes diagrams and explanations to help you understand how the platform is structured and how the different parts work together.
- **[Definitions](architecture/definitions.md)**:
  A detailed description of the key components and concepts within the IXP.
  This section serves as a glossary, helping you understand specific terms and their meanings in the context of the platform.

## Getting Started

To begin your journey with the IXP, we recommend starting with the [Installation Guide](installation.md).
This guide will help you set up the platform using Docker Compose and Nginx, ensuring that all components are correctly configured and running smoothly.
