# Authorization and User Management

This section provides details on the authorization roles, user onboarding processes, and access control mechanisms implemented in the INJECT Exercise Platform.

## Authorization

For authorization processes, the RBAC (Role-based access control) is supplemented with a modified ACL (access control list).

Three authorization roles (also called groups, not to be mistaken for in-game roles) are present:

**ADMIN**

- has access to all resources and the platform (exercises, definitions, users, etc...)
- role should be assigned only to people that really need it (maintainers, deployers of the platform), and the number of people with this role should be kept to a minimum
- can execute every action that a TRAINEE or INSTRUCTOR can

**INSTRUCTOR**

- can access only exercises and definitions where he/she was assigned (or which he/she has created and was not removed from them)
- instructors can add or remove other instructors from exercises or definitions if they have access to these resources
- by creating an exercise or uploading an exercise definition, the instructor is automatically granted access to it –
  access can be removed by the other instructor assigned to the exercise or definition
- instructor of the given exercise can see all teams in the exercise
- can manipulate with the exercises (start, stop, create, or remove)
- can add/remove trainees to/from teams of an exercise
- inherits all trainee permissions

**TRAINEE**

- can see only exercises to which he/she was assigned
- can access only the data of the team to which he or she was assigned
  (cannot see the data of other teams for the same exercise)
- can use tools in exercise (sending emails, using tools,...)

### Additional notes

Users with the ADMIN role can be added to the access control lists to be shown in exercises
(if the admin acts as an instructor for some reason),
but it is not necessary because ADMIN has control over every resource on the platform, whether he is assigned to it or not.

## User onboarding

Users can be added to the platform via a `.csv` file in the following format:

```
username,group,tags,first_name,last_name
```

**username** (mandatory)

- has to be a valid email address of the user (user will receive credentials via this email)

**group** (optional, implicitly "trainee")

- authorization role of the created user
- values: trainee, instructor, or admin (shorts "t", "i" or "a" can be used as well) case is ignored

Instructors cannot create users with higher privileges.
Admin can be created only by admin users.

**tags** (optional)

- you can mark the newly created user by tags to make your work with assigning users to teams or exercises more convenient
- format of the field: `tag1|tag2|tag3` (values separated by "|")

**first_name** (optional)

- first name of the created user if you want to identify them later

**last_name** (optional)

- last name of the created user if you want to identify them later

As a separator for the column, you can use either `,` or `;`.

An example of such a file can be [downloaded](https://gitlab.fi.muni.cz/inject/inject-docs/-/raw/main/docs/tech/example_csv.csv?ref_type=heads&inline=false).
