# INJECT Exercise Platform Documentation

Welcome to the INJECT Exercise Platform (IXP) Documentation!
Here, you'll find comprehensive resources to guide you through every aspect of the IXP, from installation to advanced usage.

## Overview

The INJECT Exercise Platform revolutionizes tabletop exercise management by
providing a versatile and intuitive solution for organizations of all sizes.
Whether you're a small team looking to improve emergency response protocols or
a large corporation conducting complex training scenarios,
IXP offers the flexibility and power to meet your needs.

## Technical Documentation

Explore the technical documentation to gain a deeper understanding of
the platform's architecture, APIs, security measures, and installation procedures.

- [Installation Guide](tech/installation.md):
  Step-by-step instructions for deploying IXP using Docker Compose and Nginx.
- [Security](tech/security.md):
  Details on the security measures and practices implemented in the IXP.
- [API Documentation](tech/api/overview.md):
  Comprehensive documentation of the APIs provided by IXP, including RESTful APIs.
- [Architecture Overview](tech/architecture/overview.md):
  Detailed documentation on the architecture of the IXP, including component definition.

## INJECT Process

Learn about the process of conducting tabletop exercises using the IXP.

- [Inject Process](INJECT_process/intro/overview.md):
  A detailed guide on how to plan, execute, and evaluate tabletop exercises using IXP.

## Additional Resources

Access supplementary materials and information related to IXP.

- **[Glossary of Terms](glossary-of-terms.md)**: Definitions of key terms and concepts used in the IXP.
- **[Report Bugs](report-bugs.md)**: Instructions for reporting bugs, issues, or providing feedback on the IXP.
- **[Acknowledgements](acknowledgements.md)**: Recognition of individuals or organizations that have contributed to the development or support of the IXP.
- **[Authors](authors.md)**: Meet the team behind the development of IXP.
