### Local variables

- `INJECT_DEBUG`: _boolean, default=false_ - Run the backend in debug mode. **Do not set in production.**
- `INJECT_HOST_ADDRESSES`: _string, default=localhost_ - A comma-separated list of allowed hosts.
- `INJECT_CORS_ALLOWED_ORIGINS`: _string, default=http://localhost_ - A comma-separated list of origins (domains) that are authorized to make cross-site HTTP requests.
- `INJECT_NOAUTH`: _boolean, default=false_ - If set, authorization is turned off. 
- `INJECT_EMAIL_HOST`: _string, default=""_ - SMTP server address.
- `INJECT_EMAIL_PORT`: _int, default=25_ - Port to use for the SMTP server defined in INJECT_EMAIL_HOST.
- `INJECT_EMAIL_HOST_USER`: _string, default=""_ - Username to use for authentication to the SMTP server defined in _INJECT_EMAIL_HOST_.
- `INJECT_EMAIL_HOST_PASSWORD`: _string, default=""_ - Password to use for the SMTP server defined in _INJECT_EMAIL_HOST_. This setting is used in conjunction with _INJECT_EMAIL_HOST_USER_ when authenticating to the SMTP server.
- `INJECT_EMAIL_SENDER_ADDRESS`: _string, default=""_ - The sender address for automatic emails.
- `INJECT_LOGS`: _string, default=backend-logs.log_ - Path to a file where to save logs.
- `INJECT_DOMAIN`: _string, default=""_ - Domain where yours instance of the INJECT is available.



### Running the Application with Docker:
There is a `Dockerfile` present in this repository, which can be used to build an image of the current version of the backend. 
Image can be built with this command:
```bash
docker build -t backend .
```
Once the image is created, you can start the container with this command:
```bash
docker run --name backend -p8000:8000 -d backend gunicorn
```
You can access the backend the way described in the same way as when running locally.

Image allows running of unit tests as well, this can be done via:
```bash
docker run --rm backend test
```


## Deployment
The backend is made to be deployed using [gunicorn](https://gunicorn.org/) with [uvicorn](https://www.uvicorn.org/) workers.
Specific versions of these servers are included in the poetry environment.
To start the server, run this one-line command:
```
poetry python -m gunicorn ttxbackend.asgi:application -k uvicorn.workers.UvicornWorker
```

This will start a gunicorn server using uvicorn workers. `uvicorn` is required because `gunicorn`
does not support websockets, which are necessary for GraphQL subscriptions.

Currently, it is not recommended to use **more than 1 worker**.

An additional environment variable `HOST_ADDRESSES` must be set with a comma-separated list of
allowed host addresses.

In Docker this can be done followingly:
```bash
docker run --name backend -e HOST_ADDRESSES="172.26.0.1,192.168.0.1" -p8000:8000 -d backend gunicorn
```