# INJECT Exercise Platform Documentation

Welcome to the INJECT Exercise Platform Documentation portal! Here, you'll find comprehensive resources to guide you through every aspect of the INJECT Exercise Platform, from installation to advanced usage.

## Overview

The INJECT Exercise Platform revolutionizes tabletop exercise management by providing a versatile and intuitive solution for organizations of all sizes. Whether you're a small team looking to improve emergency response protocols or a large corporation conducting complex training scenarios, INJECT Exercise Platform offers the flexibility and power to meet your needs.

## Technical Documentation

Explore the technical documentation to gain a deeper understanding of the platform's architecture, APIs, security measures, and installation procedures.

- **[Installation Guide](tech/installation.md)**: Step-by-step instructions for deploying INJECT Exercise Platform using Docker Compose and Nginx.
- **[Security](tech/security.md)**: Details on the security measures and practices implemented in the INJECT Exercise Platform.
- **[API Documentation](tech/api/overview.md)**: Comprehensive documentation of the APIs provided by INJECT Exercise Platform, including RESTful APIs.
- **[Architecture Overview](tech/architecture/overview.md)**: Detailed documentation on the architecture of the INJECT Exercise Platform, including component definitions and change logs.

## INJECT Process

Learn about the process of conducting tabletop exercises using the INJECT Exercise Platform.

- **[Inject Process](INJECT_process/intro/overview.md)**: A detailed guide on how to plan, execute, and evaluate tabletop exercises using INJECT Exercise Platform.

## Additional Resources

Access supplementary materials and information related to INJECT Exercise Platform.

- **[Glossary of Terms](glossary-of-terms.md)**: Definitions of key terms and concepts used in the INJECT Exercise Platform.
- **[Report Bugs](report-bugs.md)**: Instructions for reporting bugs, issues, or providing feedback on the INJECT Exercise Platform.
- **[Acknowledgements](acknowledgements.md)**: Recognition of individuals or organizations that have contributed to the development or support of the INJECT Exercise Platform.
- **[Authors](authors.md)**: Meet the team behind the development of INJECT Exercise Platform.
