# DEFINE: clearly outline exercise essentials

## In a nutshell

- This is the second phase of the INJECT process, focused on defining clear exercise objectives.
- Involves breaking down objectives into specific learning activities and creating the main and parallel inject lines to form a cohesive scenario.
- Results in a well-structured scenario that guides the entire exercise.

---

## Where are we in the INJECT process?

![](../../images/02.png)

---

!!! Disclaimer
    At this part of the documentation, we will include a guide for the Editor.
    However, please note that the Editor's functionalities are still undergoing extensive iteration.
    As a result, this section is not currently included in the documentation.

## 1. Define Learning Objectives and Activities

### Learning Objectives (LO)

A comprehensive goal of the exercise that addresses specific needs.
Learning objectives are derived from what participants should actually do during an incident or in a certain situation to handle it in the best possible way.
There can be multiple learning objectives in a single exercise, but we recommend a maximum of five.

Examples:

- LO1: Handling an incident in accordance with a defined process.
- LO2: Clear communication with all stakeholders.
- LO3: Making the right decision regarding contacting the OU and applying GDPR.
- LO4: Designing appropriate actions in response to the incident.
- LO5: Reflecting on the incident.

### Learning Activities (LA)

Learning Activity (LA):
The decomposition of learning objectives into individual, actionable tasks.
Each learning objective can have multiple learning activities, but we recommend a maximum of five.

Examples:

- LO1: Handling an incident according to a defined process.
    - LA1.1: Conduct a correct analysis of the incident and request any missing information.
    - LA1.2: Establish the incident in the ticketing system.
    - LA1.3: Apply relevant parts of the incident handling manual, such as contacting management, PR, and the officer in charge.
- LO2: Clear communication with all stakeholders.
    - LA2.1: Compose a brief email to management, outlining the minimum required information and next steps.
    - LA2.2: Draft an email to the communications team highlighting potential communication risks.
    - LA2.3: Ensure the email to the trainee is consistent with the requirements of the Initial Handling Manual.

??? "Systematic Approach to Creating Learning Activities"

    ### 1. Platform Actions for Trainees

    Firstly, understand the possible actions trainees can perform on the platform:

        - Sending an email
        - Using a tool
        - Activating an interaction element (confirmation, decision, answering a questionnaire)

    ### 2. Bloom's Taxonomy Inspiration

    Secondly, combine these actions with various actionable verbs from Bloom's taxonomy to create interesting and diverse learning activities.
    Bloom's taxonomy is a framework for categorizing educational goals and activities.
    Here are some relevant verbs for tabletop exercises:

        - Identify
        - Search
        - Summarize
        - Predict
        - Decide
        - Estimate
        - Compare
        - Examine
        - Present
        - Implement
        - Act out
        - Break down
        - Argue
        - Negotiate
        - Criticize
        - Reflect
        - Review
        - Write
        - Solve

    #### Examples

    - **Example 1:** Suppose you choose an email as an action for the trainees.
      Now, using the action words, you can realize that an email asking for a summary is different from one requiring a decision.
        - Summarize: "Compose an email summarizing the incident details and the initial response actions."
        - Decide: "Send an email deciding whether to escalate the incident to upper management."
    - **Example 2:** Asking participants to make a decision via an email versus a specific questionnaire can lead to different outcomes and experiences.
        - Email: "Draft an email explaining your decision on how to handle the data breach."
        - Questionnaire: "Complete the questionnaire to decide the next steps in the data breach protocol."

    By systematically combining platform actions with Bloom's taxonomy verbs, you can design comprehensive and engaging training experiences.

    ### 3. Alignment with the learning objectives

    Thirdly, check that created activities are aligned with the defined learning objectives.

## 2. Compose the Main Storyline

Once you have defined the desired learning activities, you can begin creating your scenario.

- **Define the Main Injects**:
  Based on the needs, goals, learning activities, and information gathered during the understanding phase, identify the main injects that will drive the exercise.

- **Align Injects with Learning Activities**:
  Ensure that each inject aligns with the learning activities it is designed to drive.
  Injects can take various forms and be delivered through different channels, such as emails, notifications, or simulated media.

- **Avoid Overloading with Injects**:
  It is not necessary to create an inject for every learning activity.
  Often, a single inject about an incident can trigger multiple learning activities.
  Focus on creating impactful injects that promote a series of related actions and decisions.

- **Iterative Process**:
  Be prepared to iterate.
  You may need to step back and modify the learning activities or injects as you refine the scenario.
  Flexibility and responsiveness to new insights are key to developing an effective exercise.

### Designing Parallel Variants

The INJECT Exercise Platform allows you to design "parallel" variants, enriching the exercise experience through conditional responses.
This means that at specific points in the exercise, the scenario can branch based on the trainee's actions.
Here’s how you can effectively design these variants:

- Identify Key Decision Points: Determine the crucial moments in the exercise where trainees' decisions or actions could lead to different outcomes.
  These points are where you can introduce parallel variants.
- Create Conditional Responses: Design responses that reflect the trainee's decisions.
  These responses should be logical consequences of their actions, enhancing realism and engagement in the exercise.

Examples:

- Decision to Pay Ransom:
  If a trainee decides to pay the ransom, the next inject will reflect this decision, potentially leading to new challenges or consequences.
- Failure to Contact PR Department:
  If a trainee forgets to contact the PR department, they will receive a hint, nudging them to take the necessary action.

## 3. Designing Add-on Storylines

In addition to the main scenario, you can enhance the exercise by designing add-on storylines.
These additional elements are not crucial for achieving the primary learning objectives but can make the exercise more engaging and realistic.

- **Identify Potential Add-ons**:
  Think of scenarios or incidents that could logically occur alongside the main storyline.
  These should be relevant but not essential to the primary objectives.

Example:

- Customer Reactions:
  Introduce an add-on storyline where trainees receive angry emails from customers reacting to the accidental blocking of a legitimate website.

## Final Remarks

While the definition phase may appear straightforward, it is often a complex and iterative process.
You will find yourself continually refining learning activities and main storyline injects.

However, don't be discouraged by the messiness of this phase.
With each scenario you define, the process becomes more streamlined and manageable.

By the end of this phase, you will have developed an exercise scenario, which serves as the cornerstone for the preparation phase.
Remember, the effort invested in crafting a robust scenario will ultimately contribute to the success of the entire exercise.

<div class="NAVIGATION" markdown>
  [&larr; 1 Understanding phase](../understand/overview.md){ .md-button }
  [3 Preparation phase &rarr;](../prepare/overview.md){ .md-button }
</div>

<div class="NAVIGATION" markdown>
  [INJECT Process Overview](../intro/overview.md){ .md-button }
</div>
