For version 2.0.0 of IXP, download [Compose preset folder for HTTPS deployment using Let's Encrypt](https://gitlab.fi.muni.cz/inject/docker-deployment/-/package_files/221/download) and follow instructions below.

## HTTPS Deployment

For HTTPS deployment, before executing `docker compose up` (see [installation](../overview.md) guide),
you need to generate HTTPS certificates.
In this configuration these certificates are generated via [Certbot](https://certbot.eff.org/) by Lets Encrypt.

This can be done via `./cert_script.sh` script which automatically generates the certificate in the current directory.
Invoke the script like so, substituting the placeholders for their respective values:
```bash
./cert_script.sh <email-address> <domain>
```
After the certificate has been generated,
an email will be sent to the provided address with additional information about the certificate.

Example usage:
```bash
./cert_script.sh admin@inject.fi.muni.cz inject.fi.muni.cz
```

Please note that by executing this script you're agreeing to Certbot's TOS and Privacy Policy,
and your email will be used for essential communication about expiration notices.

After generating the certificates, please ensure that:
- `INJECT_DOMAIN` is setup to your desired hostname in the `.env` file enclosed in the `docker/nginx/https` directory
- `INJECT_SECRET_KEY` is changed to a truly random string of characters of at least 50 characters long
- `01-substitute-env.sh` is executable via `chmod +x 01-substitute-env.sh`.

Then you may execute `docker compose up -d` and your deployment is up and running
