# definitions
This directory contains the example definitions which showcase various functionality.

## Versioning
Modified [Semver](https://semver.org/):
- **Patch** - Adding fields and files to the definition, this allows for older versions of definitions to run on newer backends. 
Sensible defaults should be selected when adding fields to allow for backwards compatibility.
- **Minor** - Modifying existing fields, such as renaming, deleting or changing their meaning. 
Such changes would either break the definition validation or it would cause unintended/incorrect behaviour.
- **Major** - No set of rules are defined, can be used for extreme changes to the definition format.


The current definition version the backend supports is the first version in the [changelog](CHANGELOG.md).


## Definition file structure
```
- content/
  - various markdown files
- files/
  - various files which are used as file attachments
- config.yml
- email.yml
- injects.yml
- milestones.yml
- tools.yml
- roles.yml
```

The `content` and `files` directories are optional, they do not need to be present if your definition does not use
the features these directories are needed for.

Furthermore, it is possible to use a directory instead of a single YAML file.
The files inside this directory must follow the same structure as the original YAML file.
For example, if you decide that the current `injects.yml` file is too big to easily navigate,
you can create a directory `injects`, inside of which you create 4 different files,
which when combined will contain the original content of the `injects.yml` file.
These files can be named in any way you like, however they must have the YAML format.

The above currently holds true for all YAML files except `config.yml`.
These approaches can be mixed and matched, meaning that if you have many injects,
but not that many tools, you can put the injects into a directory and still use a single `tools.yml` file.

Note: If the definition contains both a YAML file and a directory for the same structure,
the YAML file will be prioritized and the directory ignored.
E.g. if you have an `injects.yml` and an `injects` directory, the directory will be skipped.

## Current file formats
Below are field definitions for each file. Every field is required unless a default value is 
specified, or it is stated otherwise.

### Quick list
- [config.yml](#configyml)
- [injects.yml](#injectsyml)
- [tools.yml](#toolsyml)
- [milestones.yml](#milestonesyml)
- [email.yml](#emailyml)
- [roles.yml](#rolesyml)

### config.yml
This file contains various settings for an exercise. All advanced features are disabled by default:
- **exercise_duration**: _int_ - Duration of the exercise in minutes.
- **enable_email**: _bool, default=False_ - Enable the emails feature.
- **email_between_teams**: _bool, default=False_ - Allow emails between teams. Can only be enabled if
emails are enabled.
- **custom_email_suffix**: _string, default="mail.com"_ - Used only when email between teams is enabled. 
Changes the domain of email addresses of teams, e.g. if set to `gmail.com` team email addresses will have the form `team_name@gmail.com`.
- **team_visible_milestones**: _bool, default=False_ - Enable some milestones to be visible to trainees.
- **show_exercise_time**: _bool, default=False_ - Show the remaining duration of the ongoing exercise to trainees on the frontend.
- **enable_roles**: _bool, default=False_ - Enables use of team roles. Requires `roles.yml` file to be included in the definition.
- **version**: _string_ - semver version string of the format this definition uses, see [versioning](#versioning) for details.


### injects.yml
This file contains inject categories (ICs), which group injects, for which it only makes sense 
to send one of them to the team. An important attribute of IC is `auto`, which determines whether 
it gets evaluated and sent automatically after any of its injects meet its conditions, or is 
passed to an instructor for further evaluation once its conditions are met. If `auto` is set 
to True, the first inject in the `injects` from the top that fulfills its condition is immediately
sent to the trainees, marking the IC as resolved for the exercise, and it is no longer 
evaluated for the given team to which it was sent. If `auto` is set to False, when any of 
the injects in the IC fulfills its condition, the following happens: 
An _inject selection (IS)_ is created out of all injects in this IC that meet their conditions 
at this very point in time. This resolves the IC, which is no longer evaluated for this team, 
and the resulting IS is no longer updated, even if the conditions of the underlying injects no 
longer match. At this point, the IS is sent to the instructor, where they may (or may not) select 
one of these injects that at the time of evaluating the IC met their conditions and forward it 
to the team. This is done to cut off injects that did not meet their conditions from the IS, 
so that the instructor does not have to re-evaluate which conditions do not match manually.

Each inject category has the following fields:

- **name**: _string, unique_ - Name of the Inject Category (IC).
- **auto**: _bool_ - Whether this IC gets evaluated automatically, or is passed to an instructor once its conditions are met.
- **time**: _int, default=0_ - Minimum time in minutes since the exercise start which 
must be reached before the category is processed. Nothing happens ff the time is reached but no Injects fulfill the conditions.
- **email**: _bool_, default=False - Usable only if the email feature is enabled. If set to true, the inject will be
sent to the team as an email, and the sender of each inject has to be a valid email address defined in `email.yml`.
- **delay**: _int, default=0_ - After one of the injects in this IC is about to be sent, it gets 
delayed by this number of minutes. Works only on automatically sent injects (auto=True).
- **organization**: _string, default=""_ - Name of the organization this inject was sent from.
- **injects**: 
  - **name**: _string_ - Name of the inject.
  - **milestone_condition**: _string, default=""_ - A list of milestones that must be reached in 
  order for this inject to be sent. Multiple milestones can be separated with `and` keyword. 
  Inject may also depend on a certain milestone not being reached, in that case it has to be prepended with a `not` keyword.
  - **hidden**: _bool, default=False_ - A hidden inject is not displayed to the trainees 
  (once sent, inject is not generated). It can still reach milestones though.
  - **sender**: _string, default="Exercise"_ - Sender of an inject. In case of email injects 
  this has to be set as a valid email address defined in `email.yml`. 
  - **subject**: _string_ - Subject of the email thread. Ignored if not an email inject.
  The inject email will be sent to an existing thread with the same subject and the participants being
  the sender and the addressed team. In case no such thread exists, a new one will be created.
  - **content**: _string, default=""_ - Content of this inject. Mutually exclusive with the `content_path` field.
  - **content_path**: _string, default=""_ - Name of a markdown file that contains the content for this inject.
  Mutually exclusive with the `content` field.
  - **file_name**: _string, default=""_ - Name of a file that should be attached to this inject. 
  Has to be a file present in the `/files` directory in the exercise definition. 
  - **activate_milestone**: _string, default=""_ - A list of milestones that are activated once this inject is sent. 
  [Syntax rules](#milestone-activation) for _activate_milestone_.
  - **deactivate_milestone**: _string, default=""_ - A list of milestones that are deactivated once this inject is sent. 
  [Syntax rules](#milestone-activation) for _deactivate_milestone_.
  - **repeat**: _int, default=0_ - States how many times the inject should be repeated. 
  If set to 0, the inject will be sent only once.
  - **roles**: _string, default=""_ - Usable only if roles are enabled. Defines which roles can 
  receive this inject. If inject is meant for multiple roles, it can be achieved by writing the role names separated by spaces.
  

### tools.yml
This file contains a list of tools. A tool can be thought of as a simple function, which based on 
its input and current state of the exercise returns some output. Each tool has the following fields:
- **name**: _string, unique_ - Name of the tool
- **tooltip_description**: _string, default=""_ - Description of a tool displayed to trainees.
- **hint**: _string, default=""_ - Argument hint
- **default_response**: _string_ - Response that the tool returns if no other response gets matched.
- **roles**: _string, default=""_ - Usable only if roles are enabled. 
Defines which roles will be able to use the tool. By default, all roles can access the tool. 
If tool is meant for multiple roles, it can be achieved by writing the role names separated by spaces:
```yml
- roles: role_name_1 role_name_2 role_name_3
```
- **responses**: - A list of responses. A response is matched when its conditions are met. 
When trainees use a tool, the list of responses is examined from top to bottom and 
only the **first** matched response is sent back.
  - **param**: _string_ - A parameter that is matched **exactly** to the input of trainees. Can be written 
  as [python regular expression](https://docs.python.org/3/library/re.html) if parameter `regex` is set to true.
  - **regex**: _bool, default=False_ - Determines whether parameter `param` is matched as a string or a regex.
  - **time**: _int, default=0_ - Time since the beginning of the exercise in minutes after which this 
  response can be matched. If the trainees use correct param but this time was not reached yet, it will not match. 
  - **milestone_condition**: _string, default=""_ - A list of milestones that must be reached 
  in order for this response to get matched. Multiple milestones can be separated with `and` keyword. 
  Inject may also depend on a certain milestone not being reached, in that case it has to be prepended with a `not` keyword.
  - **content**: _string, default=""_ - This is the message that will be sent to the trainees as a response.
  Mutually exclusive with the `content_path` field.
  - **content_path**: _string, default=""_ - Name of a markdown file that contains the content for this response.
  Mutually exclusive with the `content` field.
  - **file_name**: _string, default=""_ - Name of the file which should be attached to this response when matched, 
  has to be a file present in the `/files` directory in the exercise definition. 
  - **activate_milestone**: _string, default=""_ - A list of milestones that are activated once this response is matched and sent. 
  [Syntax rules](#milestone-activation) for _activate_milestone_.
  - **deactivate_milestone**: _string, default=""_ - A list of milestones that are deactivated once this response is matched and sent. 
  [Syntax rules](#milestone-activation) for _deactivate_milestone_.
  - **roles**: _string, default=""_ - Usable only if roles are enabled. 
  Defines specific responses for specific roles. By default, this response is available for every role. 
  If response is meant for multiple roles, it can be achieved by writing the role names separated by spaces.
  

### milestones.yml
This file contains all milestones in an exercise. Any `milestone_condition` or `(de)activate_milestone` 
field in the whole definition can only contain milestones defined in here. Each milestone has the following fields:
- **name**: _string, unique_ - Name of the milestone. \
  Rules for the naming of the milestones:
   - A name must start with a letter or the underscore character
   - A name cannot start with a number
   - A name can only contain alphanumeric characters and underscores (A-z, 0-9, and _ )
   - Variable names are case-sensitive (age, Age and AGE are three different variables)
   - A name must be continuous string -> a name can not contain spaces
- **team_visible**: _bool, default=False_ - Makes a milestone visible to trainees during the exercise. 
They will be able to observe its status (whether it is reached by their team or not) in real time.
- **roles**: _string, default=""_ - Usable only if roles are enabled. Works only if the milestone is marked as visible. 
Defines, which roles will see the milestone. By default, all roles will see the milestone.
- **file_names**: _string, default=""_ - Defines the name of a file from the definition. Multiple file names
can be specified as a space separated list. If at least one of these files is downloaded, this milestone activates.
- **final**: _bool, default=False_ - sets this milestone as a final milestone. If a team reaches this
milestone, their exercise is considered to be finished. There _must_ be at least _one_ milestone, 
however there can be _more than one_.


### email.yml
This file contains all email addresses where each address has the following fields:
- **address**: _string_ - Address of the simulated correspondent. 
- **team_visible**: _bool, default=False_ - Adds this address into contact list of each team.
- **description**: _string_ - Description of the correspondent and related context for the instructor.
- **activate_milestone**: _string, default=""_ - A list of milestones that are activated once an email 
thread with this correspondent is started. This may happen automatically (through injects, prompted 
by trainees sending email to this address, or an instructor sending email to trainees from this address). 
[Syntax rules](#milestone-activation) for _activate_milestone_.
- **deactivate_milestone**: _string, default=""_ - A list of milestones that are deactivated once this inject is sent. 
[Syntax rules](#milestone-activation) for _deactivate_milestone_.
- **team_visible**: _bool, default=False_ - Specifies if this email address should be visible to the teams.
- **organization**: _string, default=""_ - Name of the organization this email address belongs to.
- **templates**: _not required_ - A list of template emails that the instructor can choose from when writing an email.
  - **context**: _string_ - Description of the context of this email answer for the instructor. 
  - **content**: _string, default=""_ - Content of this email template. Mutually exclusive with the `content_path` field.
  - **content_path**: _string, default=""_ - Name of a markdown file that contains the content for this email template.
  Mutually exclusive with the `content` field.
  - **activate_milestone**: _string, default=""_ - A list of milestones that are activated once this email template is sent by an instructor. 
  [Syntax rules](#milestone-activation) for _activate_milestone_.
  - **deactivate_milestone**: _string, default=""_ - A list of milestones that are deactivated once this email template is sent by an instructor.
  [Syntax rules](#milestone-activation) for _deactivate_milestone_.
  - **file_name**: _string, default=""_ - Filename of a file attached to this email response, 
  has to be a file present in the `/files` directory in the exercise definition. 

### roles.yml
Required if roles are enabled. This file contains all role names:
- **name**: _string_ - Name of the role.

## Syntax rules and additional information for attributes/fields
Below are specific syntax requirements for some attributes.

### Milestone activation
Both fields have the same syntax rules.

Milestones written in this fields have to be defined in `milestones.yml`.
If multiple milestones are written, they have to be separated by either _comma_, _space_, or _comma with following space_.
Following inputs are valid and recommended to use (same for _deactivate_milestone_):
```
- activate_milestone: milestone_1
- activate_milestone: milestone_1 milestone_2
- activate_milestone: milestone_1,milestone_2
- activate_milestone: milestone_1, milestone_2
```
