import { Button, Callout } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { FC } from 'react'
import { removeNotify } from '../engine'
import type { NotificationProps } from '../typing'

const notification = css`
  display: flex;
  justify-content: space-between;
  gap: 0.5rem;
  align-items: center;
`

const Notification: FC<NotificationProps> = ({ intent, msg, timestamp }) => (
  <Callout intent={intent} title={msg} className={notification}>
    <Button
      outlined
      intent={intent}
      icon='trash'
      onClick={() => removeNotify(msg, timestamp)}
    />
  </Callout>
)

export default Notification
