export const currentProtocol = (hostAddress: string) =>
  hostAddress.startsWith('localhost') ? 'http' : 'https'

export const httpGraphql = (hostAddress: string) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/graphql/`
export const httpHello = (hostAddress: string) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/version`
export const wsGraphql = (hostAddress: string) =>
  `ws${currentProtocol(hostAddress) === 'https' ? 's' : ''}://${hostAddress}/inject/api/v1/subscription/`

export const uploadDefinitionUrl = (hostAddress: string) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/exercise_definition/upload-definition`
export const validateDefinitionUrl = (hostAddress: string) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/exercise_definition/validate`
export const loginUrl = (hostAddress: string) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/auth/login/`
export const logoutUrl = (hostAddress: string) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/auth/logout/`
export const sessionUrl = (hostAddress: string) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/auth/session/`
export const downloadLogUrl = (
  hostAddress: string,
  exerciseId: string,
  anonymize: boolean
) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/running_exercise/get_exercise_logs/${exerciseId}${
    anonymize ? '?anonymize' : ''
  }`
export const downloadFileUrl = (
  hostAddress: string,
  teamId: string,
  fileId: string,
  instructor: boolean
) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/running_exercise/${teamId}/${fileId}${
    instructor ? '?instructor' : ''
  }`
export const uploadFileUrl = (hostAddress: string, teamId: string) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/running_exercise/upload/${teamId}/`
export const exportImportUrl = (hostAddress: string) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/export_import`
export const uploadUsersUrl = (hostAddress: string) =>
  `${currentProtocol(hostAddress)}://${hostAddress}/inject/api/v1/user/create-users`
