import type { EntityTitleProps } from '@blueprintjs/core'
import { Classes, Colors, Divider, EntityTitle } from '@blueprintjs/core'
import { css, cx } from '@emotion/css'
import type { FC, ReactNode } from 'react'

const wrapper = css`
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
  overflow-y: auto;
  margin: 1rem;
  /* subtract the margin */
  width: calc(100% - 2rem);
`

const message = css`
  display: flex;
  flex-direction: column;
  overflow-y: auto;
  padding: 0.5rem;
  width: calc(100%);

  border: 1px solid rgba(0, 0, 0, 0.2);
  border-radius: 0.5rem;
  .${Classes.DARK} & {
    border-color: rgba(255, 255, 255, 0.2);
  }

  box-shadow: rgba(0, 0, 0, 0.1) 0 0.125rem 0.5rem;
  transition: box-shadow 0.2s ease;
  &:hover {
    box-shadow: rgba(0, 0, 0, 0.3) 0 0.5rem 1rem;
  }
`

const warningClass = css`
  border-color: ${Colors.ORANGE2}99 !important;

  .${Classes.DARK} & {
    border-color: ${Colors.ORANGE5}99 !important;
  }
`

const fillHeight = css`
  height: 100%;
`

const headerClass = css`
  display: flex;
  justify-content: space-between;
  align-items: center;
`

const content = css`
  padding: 0.5rem;
  overflow-y: auto;
  flex: 1;
`

interface MessageProps {
  fill?: boolean
  children?: ReactNode
  header?: ReactNode
  className?: string
  warning?: boolean
  titleProps?: EntityTitleProps
}

const Message: FC<MessageProps> = ({
  fill,
  children,
  header,
  className,
  warning,
  titleProps,
}) => (
  <div
    className={cx({
      [wrapper]: true,
      [fillHeight]: fill,
      [className || '']: !!className,
    })}
  >
    {titleProps && <EntityTitle {...titleProps} />}
    <div
      className={cx({
        [message]: true,
        [warningClass]: warning,
        [fillHeight]: fill,
      })}
    >
      {header && (
        <>
          <div className={headerClass}>{header}</div>
          <Divider />
        </>
      )}

      <div className={content}>{children}</div>
    </div>
  </div>
)

export default Message
