import { useTranslation } from '@cyntler/react-doc-viewer/dist/esm/hooks/useTranslation'
import { PDFContext } from '@cyntler/react-doc-viewer/dist/esm/renderers/pdf/state'
import { css } from '@emotion/css'
import type { FC } from 'react'
import { useContext } from 'react'
import { Page } from 'react-pdf'

const pageInfo = css`
  padding-bottom: 0.25rem;
`

interface Props {
  pageNum?: number
}

const PDFSinglePage: FC<Props> = ({ pageNum }) => {
  const {
    state: { mainState, paginated, zoomLevel, numPages, currentPage },
  } = useContext(PDFContext)
  const { t } = useTranslation()

  const rendererRect = mainState?.rendererRect || null

  const pageNum2 = pageNum || currentPage

  return (
    <div id='pdf-page-wrapper'>
      {!paginated && (
        <div className={pageInfo} id='pdf-page-info'>
          {t('pdfPluginPageNumber', {
            currentPage: pageNum2,
            allPagesCount: numPages,
          })}
        </div>
      )}
      <Page
        pageNumber={pageNum2}
        scale={zoomLevel}
        height={(rendererRect?.height || 100) - 100}
        width={(rendererRect?.width || 100) - 100}
        loading={t('pdfPluginLoading')}
      />
    </div>
  )
}

export default PDFSinglePage
