import { PDFContext } from '@cyntler/react-doc-viewer/dist/esm/renderers/pdf/state'
import { css } from '@emotion/css'
import type { FC } from 'react'
import { useContext, useMemo } from 'react'
import PDFSinglePage from './PDFSinglePage'

const pages = css`
  display: flex;
  flex-direction: column;
  gap: 1rem;
`

interface Props {
  pageNum?: number
}

const PDFAllPages: FC<Props> = () => {
  const {
    state: { numPages },
  } = useContext(PDFContext)

  const pageNums = useMemo(
    () => Array.from({ length: numPages }, (_, i) => i + 1),
    [numPages]
  )

  return (
    <div className={pages}>
      {pageNums.map(pageNum => (
        <PDFSinglePage key={pageNum} pageNum={pageNum} />
      ))}
    </div>
  )
}

export default PDFAllPages
