import { css } from '@emotion/react'
import type { FC } from 'react'
import { useEffect, useState } from 'react'
import CenteredSpinner from '../../CenteredSpinner'
import type { RendererProps } from '../types'

const imageClass = css`
  max-width: 100%;
`

const ImageRenderer: FC<RendererProps> = ({ doc }) => {
  const [loading, setLoading] = useState(true)

  useEffect(() => {
    const img = new Image()
    img.src = doc.uri
    img.onload = () => setLoading(false)
  }, [doc.uri])

  if (loading) return <CenteredSpinner />

  return <img src={doc.uri} alt={doc.fileName} css={imageClass} />
}

export default ImageRenderer
