import { css } from '@emotion/css'
import type { FC, PropsWithChildren } from 'react'

const divBox = css`
  margin: 1rem;
  display: flex;
  flex-direction: column;
  justify-content: space-evenly;
  align-items: center;
  gap: 0.5rem;
  height: 100%;
`

const Box: FC<PropsWithChildren> = ({ children }) => (
  <div className={divBox}>{children}</div>
)

export default Box
