import type { UseQueryArgs } from 'urql'
import type { FragmentOf, ResultOf, VariablesOf } from '../graphql'
import { graphql, useTypedQuery } from '../graphql'

const GetChannelTypes = graphql(`
  query GetChannelTypes($exerciseId: ID!) {
    exerciseChannels(exerciseId: $exerciseId) {
      id
      type
    }
  }
`)

// eslint-disable-next-line @typescript-eslint/no-unused-vars
const FragType = graphql(`
  fragment _ on DefinitionChannelType @_unmask {
    type
  }
`)

const useChannelTypeEnabled = (
  type: FragmentOf<typeof FragType>['type'],
  params: Omit<
    UseQueryArgs<
      VariablesOf<typeof GetChannelTypes>,
      ResultOf<typeof GetChannelTypes>
    >,
    'query'
  >
) => {
  const [queryResult] = useTypedQuery({
    query: GetChannelTypes,
    ...params,
  })

  return (
    queryResult.data?.exerciseChannels?.some(
      channel => channel?.type === type
    ) || false
  )
}

export default useChannelTypeEnabled
