import { useTypedQuery, useTypedSubscription } from '../graphql'
import { GetAnalyticsEmailThreads } from '../queries'
import { exerciseEmailThreads } from '../subscriptions'

const useAnalyticsEmailThreadsSubscription = (exerciseId: string) => {
  const query = useTypedQuery({
    query: GetAnalyticsEmailThreads,
    variables: { exerciseId },
    requestPolicy: 'network-only',
  })
  useTypedSubscription({
    query: exerciseEmailThreads,
    variables: {
      exerciseId,
    },
  })

  return query
}

export default useAnalyticsEmailThreadsSubscription
