import type { Exchange } from 'urql'
import { map, pipe } from 'wonka'

const pipeLogger = (letter: string): Exchange => {
  const left = `<=${letter}`
  const right = `${letter}=>`
  return ({ forward }) =>
    op$ =>
      pipe(
        forward(
          pipe(
            op$,
            map(x => {
              new Promise(() => {
                console.log(right, x)
              })
              return x
            })
          )
        ),
        map(x => {
          new Promise(() => {
            console.log(left, x)
          })
          return x
        })
      )
}

export default pipeLogger
