import type { Cache } from '@urql/exchange-graphcache'

function invalidateUserList(cache: Cache) {
  cache.invalidate('Query', 'tags')
  cache
    .inspectFields('Query')
    .filter(x => x.fieldName === 'users')
    .forEach(x =>
      cache.invalidate('Query', x.fieldName, x.arguments ?? undefined)
    )
}

export default invalidateUserList
