import { makeExecutableSchema } from '@graphql-tools/schema'
import Keys from '@inject/shared/localstorage/keys'
import subscribedTeamsQL from '../../schemas/subscribedTeams.graphql'
import type { SubschemaConfig } from './typing'

const actionLogTodoSchema: SubschemaConfig = {
  schema: makeExecutableSchema({
    typeDefs: [subscribedTeamsQL],
    resolvers: {
      Mutation: {
        setSubscriptionTeam: (_, { teamId, state }) => {
          localStorage.setItem(Keys.getTeamSubscriptionKey(teamId), state)
          return {
            operationDone: true,
          }
        },
      },
    },
  }),
}

export default actionLogTodoSchema
