import { makeExecutableSchema } from '@graphql-tools/schema'
import Keys from '@inject/shared/localstorage/keys'
import actionLogTodoQL from '../../schemas/actionLogTodo.graphql'
import type { SubschemaConfig } from './typing'

const actionLogTodoSchema: SubschemaConfig = {
  schema: makeExecutableSchema({
    typeDefs: [actionLogTodoQL],
    resolvers: {
      Mutation: {
        setTodoActionLog: (_, { actionLogId, state }) => {
          localStorage.setItem(Keys.getActionLogTodoKey(actionLogId), state)
          return {
            operationDone: true,
          }
        },
        setEmailTodo: (_, { emailId, state }) => {
          localStorage.setItem(Keys.getEmailTodoKey(emailId), state)
          return {
            operationDone: true,
          }
        },
        setTeamQuestionnaireTodo: (_, { questionnaireId, teamId, state }) => {
          localStorage.setItem(
            Keys.getQuestionnaireTodoKey(questionnaireId, teamId),
            state
          )
          return {
            operationDone: true,
          }
        },
        setArchiveEmail: (_, { emailThreadId, state }) => {
          localStorage.setItem(
            Keys.getEmailThreadArchiveKey(emailThreadId),
            state
          )
          return {
            operationDone: true,
          }
        },
      },
    },
  }),
}

export default actionLogTodoSchema
