import { FragmentOf } from 'gql.tada'
import { ActionLog } from '../fragments'

declare global {
  interface WindowEventMap {
    actionLogEvent: CustomEvent<ActionLogPayload>
    // internal kill-switch, to ensure resuscitation of WS
    killWs: CustomEvent<never>
  }
}

// Note: payload behaves differently depending on subscription/trainee.ts and subscription/instructor.ts
// instructor currently receives the payload whenever any change occurs
// trainee receives the payload only when a new actionlog comes in
export type ActionLogPayload = {
  actionLog: FragmentOf<typeof ActionLog>
}

export {} //keep that for TS compiler.
