import { graphql } from './graphql'

import * as FragmentsClient from './fragments.client'

export const GetEmailDraft = graphql(
  `
    query GetEmailDraft(
      $teamId: ID!
      $instructor: Boolean!
      $emailThreadId: ID
    ) {
      getEmailDraft(
        teamId: $teamId
        instructor: $instructor
        emailThreadId: $emailThreadId
      ) @client {
        ...EmailDraft
      }
    }
  `,
  [FragmentsClient.EmailDraft]
)

export const GetEmailDrafts = graphql(
  `
    query GetEmailDrafts($teamId: ID!, $instructor: Boolean!) {
      getEmailDrafts(teamId: $teamId, instructor: $instructor) @client {
        ...EmailDraft
      }
    }
  `,
  [FragmentsClient.EmailDraft]
)
