import { writeFileSync } from 'fs'
import { join } from 'path'

// Combine all fragments
import * as Fragments from './fragments'
import * as ClientFragments from './fragments.client'
const allFragments = {
  ...Fragments,
  ...ClientFragments,
}

// Generate the content for `fragment-types.ts`
const content =
  `/* prettier-ignore */\n` +
  `import type { FragmentOf } from 'gql.tada'\nimport * as Fragments from './fragments';\nimport * as ClientFragments from './fragments.client';\n// eslint-disable-next-line @typescript-eslint/no-unused-vars\nconst allFragments = {\n  ...Fragments,\n  ...ClientFragments,\n};\n${Object.keys(
    allFragments
  )
    .map(
      key => `export type ${key} = FragmentOf<typeof allFragments['${key}']>;`
    )
    .join('\n')}`

// Write the content to `fragment-types.ts`
writeFileSync(join(__dirname, 'fragment-types.ts'), content)
