import { useMemo } from 'react'
import { useTypedQuery } from '../graphql'
import { Identity } from '../queries'

export const useAuthIdentity = () => {
  const [{ data, fetching }] = useTypedQuery({
    query: Identity,
  })
  const { id, isActive, group } = data?.whoAmI ?? {}

  return useMemo(
    () => ({
      id,
      isActive,
      isStaff: group === 'ADMIN' || group === 'INSTRUCTOR',
      isSuperuser: group === 'ADMIN',
      isLogged: !!data?.whoAmI,
      loading: fetching,
      whoAmI: data?.whoAmI,
    }),
    [data?.whoAmI, fetching, group, id, isActive]
  )
}

export default useAuthIdentity
