#!/bin/sh

# This script substitutes environment variables in index.html
# window.VITE_HTTPS_HOST = undefined changes to window.VITE_HTTPS_HOST = 'http://localhost:3000'

# The script is called during run time in the Dockerfile, script assumes that envvars may change during reloads

if [ -z "${VITE_HTTPS_HOST}" ]; then
  echo "VITE_HTTPS_HOST is not set. Using default value."
  sed -i "s|window.VITE_HTTPS_HOST = .*|window.VITE_HTTPS_HOST = undefined|g" /usr/app/index.html
else
  echo "VITE_HTTPS_HOST is set to ${VITE_HTTPS_HOST}"
  sed -i "s|window.VITE_HTTPS_HOST = .*|window.VITE_HTTPS_HOST = '${VITE_HTTPS_HOST}'|g" /usr/app/index.html
fi
