import { Button, Callout, Collapse, Colors } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { useLoopStatus } from '@inject/graphql/utils/useExerciseLoopStatusSubscription'
import { useEffect, useState } from 'react'

const StopAnnounce = () => {
  const { running, loading } = useLoopStatus()
  const [open, setOpen] = useState(false)

  useEffect(() => {
    if (running === false && !loading) {
      setOpen(true)
    } else if (loading || (running && !loading)) {
      setOpen(false)
    }
  }, [running, loading])

  return (
    <Collapse isOpen={open}>
      <Callout
        intent='warning'
        icon='warning-sign'
        className={css`
          display: flex;
          background-color: ${Colors.ORANGE1} !important;
        `}
      >
        <span>This exercise had been stopped</span>
        <Button
          icon='cross'
          style={{
            minHeight: '16px',
            minWidth: '16px',
            padding: 0,
            marginLeft: 'auto',
          }}
          minimal
          onClick={() => setOpen(false)}
        />
      </Callout>
    </Collapse>
  )
}

export default StopAnnounce
