import { useNavigate } from '@/router'
import { Button } from '@blueprintjs/core'
import type { FC } from 'react'

const OverviewButton: FC<{
  hideLabel?: boolean
  exerciseId?: string
}> = ({ hideLabel, exerciseId }) => {
  const nav = useNavigate()

  /*
   * Button should work when team is enabled, or in exceptional cases when exerciseId is known
   *
   */

  return (
    <Button
      icon='feed'
      alignText='left'
      fill
      minimal
      title='Overview all teams'
      disabled={!exerciseId}
      onClick={() => {
        // eslint-disable-next-line @typescript-eslint/no-unused-expressions
        !!exerciseId &&
          nav('/instructor/:exerciseId', {
            params: {
              exerciseId,
            },
          })
      }}
      text={!hideLabel && 'Overview'}
    />
  )
}

export default OverviewButton
