import InjectMessage from '@/actionlog/InjectMessage'
import { Button, NonIdealState } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { useTypedQuery } from '@inject/graphql/graphql'
import { GetSingleActionLog } from '@inject/graphql/queries'
import Container from '@inject/shared/components/Container'
import useInInstructor from '@inject/shared/hooks/useInInstructor'
import { useMemo, type FC } from 'react'

const wrapper = css`
  display: flex;
  flex-direction: column;
  align-items: flex-start;
  height: 100%;
  width: 100%;
`

interface InjectMessageViewProps {
  teamId: string
  exerciseId: string
  actionLogId: string
  onBack: () => void
}

const InjectMessageView: FC<InjectMessageViewProps> = ({
  teamId,
  exerciseId,
  actionLogId,
  onBack,
}) => {
  const [{ data }] = useTypedQuery({
    query: GetSingleActionLog,
    variables: {
      logId: actionLogId,
    },
    context: useMemo(
      () => ({
        suspense: true,
      }),
      []
    ),
  })

  const inInstructor = useInInstructor()

  if (data?.actionLog.team.id !== teamId) {
    return (
      <NonIdealState
        title='ActionLog for different team'
        description='Hmm, this ActionLog seems to be belong to another team'
      />
    )
  }

  return (
    <Container>
      <div className={wrapper}>
        <Button icon='chevron-left' text='Back' minimal onClick={onBack} />
        {data?.actionLog && (
          <InjectMessage
            exerciseId={exerciseId}
            teamId={teamId}
            fill
            actionLog={data.actionLog}
            inInstructor={inInstructor}
          />
        )}
      </div>
    </Container>
  )
}

export default InjectMessageView
