import Filters from '@/components/Filters'
import { Checkbox } from '@blueprintjs/core'
import type { FC } from 'react'
import { type Filter, type UserProperty } from '../utils'

const Columns: FC<Filter<UserProperty[]>> = ({ selected, setSelected }) => {
  const filters = (
    <>
      {selected.map(currentProperty => (
        <Checkbox
          key={currentProperty.name}
          label={currentProperty.name}
          checked={currentProperty.display}
          onChange={() =>
            setSelected(prev =>
              prev.map(property =>
                property.name === currentProperty.name
                  ? { ...property, display: !property.display }
                  : property
              )
            )
          }
        />
      ))}
    </>
  )

  return (
    <Filters
      fill
      heading='Select columns'
      noWrap
      content={filters}
      icon='column-layout'
      position='left'
      onSelectAll={() =>
        setSelected(prev =>
          prev.map(property => ({ ...property, display: true }))
        )
      }
      onDeselectAll={() =>
        setSelected(prev =>
          prev.map(property => ({ ...property, display: false }))
        )
      }
    />
  )
}

export default Columns
