import { Button } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { FC } from 'react'

const listItem = css`
  display: flex;
  gap: 0.25rem;
  align-items: center;
`

interface ListItemProps {
  name: string
  onClick: () => void
}

const ListItem: FC<ListItemProps> = ({ name, onClick }) => (
  <div className={listItem}>
    {name}
    <Button minimal icon='annotation' onClick={onClick} />
  </div>
)

export default ListItem
