import { ButtonGroup, Divider, Section, SectionCard } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { Team } from '@inject/graphql/fragment-types'
import responsiveButtonGroup from '@inject/shared/css/responsiveButtonGroup'
import { Fragment, type FC } from 'react'
import AssignByTags from './AssignByTags'
import AssignEqually from './AssignEqually'
import TeamComponent from './Team'
import { bodySection } from './classes'

const body = css`
  display: flex;
  flex-direction: column;
  gap: 1rem;
`

interface TeamsProps {
  teams: Team[]
  exerciseId: string
}

const Teams: FC<TeamsProps> = ({ teams, exerciseId }) => (
  <>
    <Section
      title='Teams'
      icon='team'
      className={bodySection}
      rightElement={
        <ButtonGroup minimal className={responsiveButtonGroup}>
          <AssignEqually exerciseId={exerciseId} teamCount={teams.length} />
          <Divider />
          <AssignByTags exerciseId={exerciseId} />
        </ButtonGroup>
      }
    >
      <SectionCard padded className={body}>
        {teams.map(team => (
          <Fragment key={team.id}>
            <TeamComponent team={team} />
          </Fragment>
        ))}
      </SectionCard>
    </Section>
  </>
)

export default Teams
