import EditorPage from '@/editor/EditorPage'
import GitlabSettings from '@/editor/GitlabSettings'
import { PageNames } from '@/editor/types'
import { memo } from 'react'
import { useLocation } from 'react-router-dom'

const EditorGitlabSettingsPage = () => {
  const location = useLocation()

  return (
    <EditorPage
      pageKey={PageNames.GITLAB}
      prevPath={location.state ? '/editor' : '/editor/definitions'}
      pageVisible
      nextVisible={false}
    >
      <GitlabSettings prevPath='/editor/definitions' />
    </EditorPage>
  )
}

export default memo(EditorGitlabSettingsPage)
