import EditorPage from '@/editor/EditorPage'
import ToolForm from '@/editor/ToolForm'
import Tools from '@/editor/Tools'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const ToolsPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.TOOLS}
      prevPath='/editor/create/other'
      nextVisible={false}
      pageVisible={access?.injectsFilled}
    >
      <Tools />
      <ToolForm
        buttonProps={{
          minimal: true,
          text: 'Add tool',
          alignText: 'left',
          icon: 'plus',
          style: { padding: '1rem', width: '100%' },
        }}
      />
    </EditorPage>
  )
}

export default memo(ToolsPage)
