import EditorPage from '@/editor/EditorPage'
import InjectForm from '@/editor/InjectForm'
import Injects from '@/editor/Injects'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const InjectsPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.INJECTS}
      prevPath='/editor/create/learning-objectives'
      nextPath='/editor/create/activity-specification'
      pageVisible={access?.objectivesFilled}
      nextDisabled={!access?.injectsFilled}
    >
      <Injects />
      <InjectForm
        buttonProps={{
          minimal: true,
          text: 'Add new inject',
          alignText: 'left',
          icon: 'plus',
          style: { padding: '1rem', width: '100%' },
        }}
      />
    </EditorPage>
  )
}

export default memo(InjectsPage)
