import EditorPage from '@/editor/EditorPage'
import InjectsOverview from '@/editor/InjectsOverview'
import { PageNames } from '@/editor/types'
import useEditorAccessStorage from '@/editor/useEditorAccessStorage'
import { memo } from 'react'

const ActivitiesSpecificationPage = () => {
  const [access] = useEditorAccessStorage()

  return (
    <EditorPage
      pageKey={PageNames.INJECT_SPECIFICATION_OVERVIEW}
      prevPath='/editor/create/activity-specification'
      nextPath='/editor/create/other'
      pageVisible={access?.injectsFilled}
    >
      <InjectsOverview />
    </EditorPage>
  )
}

export default memo(ActivitiesSpecificationPage)
